package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeLocationAzureBlobRequest(locationArn: LocationArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobRequest = {
    import DescribeLocationAzureBlobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationAzureBlobRequest.ReadOnly =
    zio.aws.datasync.model.DescribeLocationAzureBlobRequest
      .wrap(buildAwsValue())
}
object DescribeLocationAzureBlobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationAzureBlobRequest =
      zio.aws.datasync.model.DescribeLocationAzureBlobRequest(locationArn)
    def locationArn: LocationArn
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobRequest
  ) extends zio.aws.datasync.model.DescribeLocationAzureBlobRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobRequest
  ): zio.aws.datasync.model.DescribeLocationAzureBlobRequest.ReadOnly =
    new Wrapper(impl)
}
