package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait NfsVersion {
  def unwrap: software.amazon.awssdk.services.datasync.model.NfsVersion
}
object NfsVersion {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.NfsVersion
  ): zio.aws.datasync.model.NfsVersion = value match {
    case software.amazon.awssdk.services.datasync.model.NfsVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.NfsVersion.AUTOMATIC =>
      val r = AUTOMATIC
      r
    case software.amazon.awssdk.services.datasync.model.NfsVersion.NFS3 =>
      val r = NFS3
      r
    case software.amazon.awssdk.services.datasync.model.NfsVersion.NFS4_0 =>
      val r = NFS4_0
      r
    case software.amazon.awssdk.services.datasync.model.NfsVersion.NFS4_1 =>
      val r = NFS4_1
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.NfsVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.NfsVersion =
      software.amazon.awssdk.services.datasync.model.NfsVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTOMATIC extends zio.aws.datasync.model.NfsVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.NfsVersion =
      software.amazon.awssdk.services.datasync.model.NfsVersion.AUTOMATIC
  }
  case object NFS3 extends zio.aws.datasync.model.NfsVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.NfsVersion =
      software.amazon.awssdk.services.datasync.model.NfsVersion.NFS3
  }
  case object NFS4_0 extends zio.aws.datasync.model.NfsVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.NfsVersion =
      software.amazon.awssdk.services.datasync.model.NfsVersion.NFS4_0
  }
  case object NFS4_1 extends zio.aws.datasync.model.NfsVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.NfsVersion =
      software.amazon.awssdk.services.datasync.model.NfsVersion.NFS4_1
  }
}
