package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.DiscoveryNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStorageSystemResourcesResponse(
    resourceDetails: Optional[zio.aws.datasync.model.ResourceDetails] =
      Optional.Absent,
    nextToken: Optional[DiscoveryNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse = {
    import DescribeStorageSystemResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse
      .builder()
      .optionallyWith(resourceDetails.map(value => value.buildAwsValue()))(
        _.resourceDetails
      )
      .optionallyWith(
        nextToken.map(value =>
          DiscoveryNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeStorageSystemResourcesResponse.ReadOnly =
    zio.aws.datasync.model.DescribeStorageSystemResourcesResponse
      .wrap(buildAwsValue())
}
object DescribeStorageSystemResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datasync.model.DescribeStorageSystemResourcesResponse =
      zio.aws.datasync.model.DescribeStorageSystemResourcesResponse(
        resourceDetails.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def resourceDetails
        : Optional[zio.aws.datasync.model.ResourceDetails.ReadOnly]
    def nextToken: Optional[DiscoveryNextToken]
    def getResourceDetails
        : ZIO[Any, AwsError, zio.aws.datasync.model.ResourceDetails.ReadOnly] =
      AwsError.unwrapOptionField("resourceDetails", resourceDetails)
    def getNextToken: ZIO[Any, AwsError, DiscoveryNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse
  ) extends zio.aws.datasync.model.DescribeStorageSystemResourcesResponse.ReadOnly {
    override val resourceDetails
        : Optional[zio.aws.datasync.model.ResourceDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceDetails())
        .map(value => zio.aws.datasync.model.ResourceDetails.wrap(value))
    override val nextToken: Optional[DiscoveryNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesResponse
  ): zio.aws.datasync.model.DescribeStorageSystemResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
