package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  DiscoveryNextToken,
  DiscoveryMaxResults,
  StorageSystemArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDiscoveryJobsRequest(
    storageSystemArn: Optional[StorageSystemArn] = Optional.Absent,
    maxResults: Optional[DiscoveryMaxResults] = Optional.Absent,
    nextToken: Optional[DiscoveryNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest = {
    import ListDiscoveryJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest
      .builder()
      .optionallyWith(
        storageSystemArn.map(value =>
          StorageSystemArn.unwrap(value): java.lang.String
        )
      )(_.storageSystemArn)
      .optionallyWith(
        maxResults.map(value => DiscoveryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          DiscoveryNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListDiscoveryJobsRequest.ReadOnly =
    zio.aws.datasync.model.ListDiscoveryJobsRequest.wrap(buildAwsValue())
}
object ListDiscoveryJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListDiscoveryJobsRequest =
      zio.aws.datasync.model.ListDiscoveryJobsRequest(
        storageSystemArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def storageSystemArn: Optional[StorageSystemArn]
    def maxResults: Optional[DiscoveryMaxResults]
    def nextToken: Optional[DiscoveryNextToken]
    def getStorageSystemArn: ZIO[Any, AwsError, StorageSystemArn] =
      AwsError.unwrapOptionField("storageSystemArn", storageSystemArn)
    def getMaxResults: ZIO[Any, AwsError, DiscoveryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, DiscoveryNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest
  ) extends zio.aws.datasync.model.ListDiscoveryJobsRequest.ReadOnly {
    override val storageSystemArn: Optional[StorageSystemArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageSystemArn())
        .map(value => zio.aws.datasync.model.primitives.StorageSystemArn(value))
    override val maxResults: Optional[DiscoveryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.datasync.model.primitives.DiscoveryMaxResults(value)
        )
    override val nextToken: Optional[DiscoveryNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest
  ): zio.aws.datasync.model.ListDiscoveryJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
