package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaskExecutionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelTaskExecutionRequest(
    taskExecutionArn: TaskExecutionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest = {
    import CancelTaskExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest
      .builder()
      .taskExecutionArn(
        TaskExecutionArn.unwrap(taskExecutionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CancelTaskExecutionRequest.ReadOnly =
    zio.aws.datasync.model.CancelTaskExecutionRequest.wrap(buildAwsValue())
}
object CancelTaskExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CancelTaskExecutionRequest =
      zio.aws.datasync.model.CancelTaskExecutionRequest(taskExecutionArn)
    def taskExecutionArn: TaskExecutionArn
    def getTaskExecutionArn: ZIO[Any, Nothing, TaskExecutionArn] =
      ZIO.succeed(taskExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest
  ) extends zio.aws.datasync.model.CancelTaskExecutionRequest.ReadOnly {
    override val taskExecutionArn: TaskExecutionArn =
      zio.aws.datasync.model.primitives
        .TaskExecutionArn(impl.taskExecutionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest
  ): zio.aws.datasync.model.CancelTaskExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
