package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.FilterValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FilterRule(
    filterType: Optional[zio.aws.datasync.model.FilterType] = Optional.Absent,
    value: Optional[FilterValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.FilterRule = {
    import FilterRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.FilterRule
      .builder()
      .optionallyWith(filterType.map(value => value.unwrap))(_.filterType)
      .optionallyWith(
        value.map(value => FilterValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.FilterRule.ReadOnly =
    zio.aws.datasync.model.FilterRule.wrap(buildAwsValue())
}
object FilterRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.FilterRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.FilterRule = zio.aws.datasync.model
      .FilterRule(filterType.map(value => value), value.map(value => value))
    def filterType: Optional[zio.aws.datasync.model.FilterType]
    def value: Optional[FilterValue]
    def getFilterType: ZIO[Any, AwsError, zio.aws.datasync.model.FilterType] =
      AwsError.unwrapOptionField("filterType", filterType)
    def getValue: ZIO[Any, AwsError, FilterValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.FilterRule
  ) extends zio.aws.datasync.model.FilterRule.ReadOnly {
    override val filterType: Optional[zio.aws.datasync.model.FilterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterType())
        .map(value => zio.aws.datasync.model.FilterType.wrap(value))
    override val value: Optional[FilterValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.datasync.model.primitives.FilterValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.FilterRule
  ): zio.aws.datasync.model.FilterRule.ReadOnly = new Wrapper(impl)
}
