package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.AgentArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAgentRequest(agentArn: AgentArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeAgentRequest = {
    import DescribeAgentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeAgentRequest
      .builder()
      .agentArn(AgentArn.unwrap(agentArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeAgentRequest.ReadOnly =
    zio.aws.datasync.model.DescribeAgentRequest.wrap(buildAwsValue())
}
object DescribeAgentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeAgentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeAgentRequest =
      zio.aws.datasync.model.DescribeAgentRequest(agentArn)
    def agentArn: AgentArn
    def getAgentArn: ZIO[Any, Nothing, AgentArn] = ZIO.succeed(agentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeAgentRequest
  ) extends zio.aws.datasync.model.DescribeAgentRequest.ReadOnly {
    override val agentArn: AgentArn =
      zio.aws.datasync.model.primitives.AgentArn(impl.agentArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeAgentRequest
  ): zio.aws.datasync.model.DescribeAgentRequest.ReadOnly = new Wrapper(impl)
}
