package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait TaskExecutionStatus {
  def unwrap: software.amazon.awssdk.services.datasync.model.TaskExecutionStatus
}
object TaskExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.TaskExecutionStatus
  ): zio.aws.datasync.model.TaskExecutionStatus = value match {
    case software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.LAUNCHING =>
      val r = LAUNCHING
      r
    case software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.PREPARING =>
      val r = PREPARING
      r
    case software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.TRANSFERRING =>
      val r = TRANSFERRING
      r
    case software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.VERIFYING =>
      val r = VERIFYING
      r
    case software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.TaskExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskExecutionStatus =
      software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUED extends zio.aws.datasync.model.TaskExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskExecutionStatus =
      software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.QUEUED
  }
  case object LAUNCHING extends zio.aws.datasync.model.TaskExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskExecutionStatus =
      software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.LAUNCHING
  }
  case object PREPARING extends zio.aws.datasync.model.TaskExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskExecutionStatus =
      software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.PREPARING
  }
  case object TRANSFERRING extends zio.aws.datasync.model.TaskExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskExecutionStatus =
      software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.TRANSFERRING
  }
  case object VERIFYING extends zio.aws.datasync.model.TaskExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskExecutionStatus =
      software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.VERIFYING
  }
  case object SUCCESS extends zio.aws.datasync.model.TaskExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskExecutionStatus =
      software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.SUCCESS
  }
  case object ERROR extends zio.aws.datasync.model.TaskExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TaskExecutionStatus =
      software.amazon.awssdk.services.datasync.model.TaskExecutionStatus.ERROR
  }
}
