package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAgentsResponse(
    agents: Optional[Iterable[zio.aws.datasync.model.AgentListEntry]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListAgentsResponse = {
    import ListAgentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListAgentsResponse
      .builder()
      .optionallyWith(
        agents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.agents)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListAgentsResponse.ReadOnly =
    zio.aws.datasync.model.ListAgentsResponse.wrap(buildAwsValue())
}
object ListAgentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListAgentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListAgentsResponse =
      zio.aws.datasync.model.ListAgentsResponse(
        agents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def agents: Optional[List[zio.aws.datasync.model.AgentListEntry.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAgents: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.AgentListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("agents", agents)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListAgentsResponse
  ) extends zio.aws.datasync.model.ListAgentsResponse.ReadOnly {
    override val agents
        : Optional[List[zio.aws.datasync.model.AgentListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.agents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.AgentListEntry.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListAgentsResponse
  ): zio.aws.datasync.model.ListAgentsResponse.ReadOnly = new Wrapper(impl)
}
