package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.IamRoleArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3Config(bucketAccessRoleArn: IamRoleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.S3Config = {
    import S3Config.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.S3Config
      .builder()
      .bucketAccessRoleArn(
        IamRoleArn.unwrap(bucketAccessRoleArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.S3Config.ReadOnly =
    zio.aws.datasync.model.S3Config.wrap(buildAwsValue())
}
object S3Config {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datasync.model.S3Config] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.S3Config =
      zio.aws.datasync.model.S3Config(bucketAccessRoleArn)
    def bucketAccessRoleArn: IamRoleArn
    def getBucketAccessRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(bucketAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.S3Config
  ) extends zio.aws.datasync.model.S3Config.ReadOnly {
    override val bucketAccessRoleArn: IamRoleArn =
      zio.aws.datasync.model.primitives.IamRoleArn(impl.bucketAccessRoleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.S3Config
  ): zio.aws.datasync.model.S3Config.ReadOnly = new Wrapper(impl)
}
