package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait HdfsAuthenticationType {
  def unwrap
      : software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType
}
object HdfsAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType
  ): zio.aws.datasync.model.HdfsAuthenticationType = value match {
    case software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType.SIMPLE =>
      val r = SIMPLE
      r
    case software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType.KERBEROS =>
      val r = KERBEROS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.HdfsAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType =
      software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object SIMPLE extends zio.aws.datasync.model.HdfsAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType =
      software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType.SIMPLE
  }
  case object KERBEROS extends zio.aws.datasync.model.HdfsAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType =
      software.amazon.awssdk.services.datasync.model.HdfsAuthenticationType.KERBEROS
  }
}
