package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeLocationEfsRequest(locationArn: LocationArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest = {
    import DescribeLocationEfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationEfsRequest.ReadOnly =
    zio.aws.datasync.model.DescribeLocationEfsRequest.wrap(buildAwsValue())
}
object DescribeLocationEfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationEfsRequest =
      zio.aws.datasync.model.DescribeLocationEfsRequest(locationArn)
    def locationArn: LocationArn
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest
  ) extends zio.aws.datasync.model.DescribeLocationEfsRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest
  ): zio.aws.datasync.model.DescribeLocationEfsRequest.ReadOnly = new Wrapper(
    impl
  )
}
