package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.BytesPerSecond
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Options(
    verifyMode: Optional[zio.aws.datasync.model.VerifyMode] = Optional.Absent,
    overwriteMode: Optional[zio.aws.datasync.model.OverwriteMode] =
      Optional.Absent,
    atime: Optional[zio.aws.datasync.model.Atime] = Optional.Absent,
    mtime: Optional[zio.aws.datasync.model.Mtime] = Optional.Absent,
    uid: Optional[zio.aws.datasync.model.Uid] = Optional.Absent,
    gid: Optional[zio.aws.datasync.model.Gid] = Optional.Absent,
    preserveDeletedFiles: Optional[
      zio.aws.datasync.model.PreserveDeletedFiles
    ] = Optional.Absent,
    preserveDevices: Optional[zio.aws.datasync.model.PreserveDevices] =
      Optional.Absent,
    posixPermissions: Optional[zio.aws.datasync.model.PosixPermissions] =
      Optional.Absent,
    bytesPerSecond: Optional[BytesPerSecond] = Optional.Absent,
    taskQueueing: Optional[zio.aws.datasync.model.TaskQueueing] =
      Optional.Absent,
    logLevel: Optional[zio.aws.datasync.model.LogLevel] = Optional.Absent,
    transferMode: Optional[zio.aws.datasync.model.TransferMode] =
      Optional.Absent,
    securityDescriptorCopyFlags: Optional[
      zio.aws.datasync.model.SmbSecurityDescriptorCopyFlags
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.Options = {
    import Options.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.Options
      .builder()
      .optionallyWith(verifyMode.map(value => value.unwrap))(_.verifyMode)
      .optionallyWith(overwriteMode.map(value => value.unwrap))(_.overwriteMode)
      .optionallyWith(atime.map(value => value.unwrap))(_.atime)
      .optionallyWith(mtime.map(value => value.unwrap))(_.mtime)
      .optionallyWith(uid.map(value => value.unwrap))(_.uid)
      .optionallyWith(gid.map(value => value.unwrap))(_.gid)
      .optionallyWith(preserveDeletedFiles.map(value => value.unwrap))(
        _.preserveDeletedFiles
      )
      .optionallyWith(preserveDevices.map(value => value.unwrap))(
        _.preserveDevices
      )
      .optionallyWith(posixPermissions.map(value => value.unwrap))(
        _.posixPermissions
      )
      .optionallyWith(
        bytesPerSecond.map(value =>
          BytesPerSecond.unwrap(value): java.lang.Long
        )
      )(_.bytesPerSecond)
      .optionallyWith(taskQueueing.map(value => value.unwrap))(_.taskQueueing)
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .optionallyWith(transferMode.map(value => value.unwrap))(_.transferMode)
      .optionallyWith(securityDescriptorCopyFlags.map(value => value.unwrap))(
        _.securityDescriptorCopyFlags
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.Options.ReadOnly =
    zio.aws.datasync.model.Options.wrap(buildAwsValue())
}
object Options {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datasync.model.Options] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.Options =
      zio.aws.datasync.model.Options(
        verifyMode.map(value => value),
        overwriteMode.map(value => value),
        atime.map(value => value),
        mtime.map(value => value),
        uid.map(value => value),
        gid.map(value => value),
        preserveDeletedFiles.map(value => value),
        preserveDevices.map(value => value),
        posixPermissions.map(value => value),
        bytesPerSecond.map(value => value),
        taskQueueing.map(value => value),
        logLevel.map(value => value),
        transferMode.map(value => value),
        securityDescriptorCopyFlags.map(value => value)
      )
    def verifyMode: Optional[zio.aws.datasync.model.VerifyMode]
    def overwriteMode: Optional[zio.aws.datasync.model.OverwriteMode]
    def atime: Optional[zio.aws.datasync.model.Atime]
    def mtime: Optional[zio.aws.datasync.model.Mtime]
    def uid: Optional[zio.aws.datasync.model.Uid]
    def gid: Optional[zio.aws.datasync.model.Gid]
    def preserveDeletedFiles
        : Optional[zio.aws.datasync.model.PreserveDeletedFiles]
    def preserveDevices: Optional[zio.aws.datasync.model.PreserveDevices]
    def posixPermissions: Optional[zio.aws.datasync.model.PosixPermissions]
    def bytesPerSecond: Optional[BytesPerSecond]
    def taskQueueing: Optional[zio.aws.datasync.model.TaskQueueing]
    def logLevel: Optional[zio.aws.datasync.model.LogLevel]
    def transferMode: Optional[zio.aws.datasync.model.TransferMode]
    def securityDescriptorCopyFlags
        : Optional[zio.aws.datasync.model.SmbSecurityDescriptorCopyFlags]
    def getVerifyMode: ZIO[Any, AwsError, zio.aws.datasync.model.VerifyMode] =
      AwsError.unwrapOptionField("verifyMode", verifyMode)
    def getOverwriteMode
        : ZIO[Any, AwsError, zio.aws.datasync.model.OverwriteMode] =
      AwsError.unwrapOptionField("overwriteMode", overwriteMode)
    def getAtime: ZIO[Any, AwsError, zio.aws.datasync.model.Atime] =
      AwsError.unwrapOptionField("atime", atime)
    def getMtime: ZIO[Any, AwsError, zio.aws.datasync.model.Mtime] =
      AwsError.unwrapOptionField("mtime", mtime)
    def getUid: ZIO[Any, AwsError, zio.aws.datasync.model.Uid] =
      AwsError.unwrapOptionField("uid", uid)
    def getGid: ZIO[Any, AwsError, zio.aws.datasync.model.Gid] =
      AwsError.unwrapOptionField("gid", gid)
    def getPreserveDeletedFiles
        : ZIO[Any, AwsError, zio.aws.datasync.model.PreserveDeletedFiles] =
      AwsError.unwrapOptionField("preserveDeletedFiles", preserveDeletedFiles)
    def getPreserveDevices
        : ZIO[Any, AwsError, zio.aws.datasync.model.PreserveDevices] =
      AwsError.unwrapOptionField("preserveDevices", preserveDevices)
    def getPosixPermissions
        : ZIO[Any, AwsError, zio.aws.datasync.model.PosixPermissions] =
      AwsError.unwrapOptionField("posixPermissions", posixPermissions)
    def getBytesPerSecond: ZIO[Any, AwsError, BytesPerSecond] =
      AwsError.unwrapOptionField("bytesPerSecond", bytesPerSecond)
    def getTaskQueueing
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskQueueing] =
      AwsError.unwrapOptionField("taskQueueing", taskQueueing)
    def getLogLevel: ZIO[Any, AwsError, zio.aws.datasync.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
    def getTransferMode
        : ZIO[Any, AwsError, zio.aws.datasync.model.TransferMode] =
      AwsError.unwrapOptionField("transferMode", transferMode)
    def getSecurityDescriptorCopyFlags: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.SmbSecurityDescriptorCopyFlags
    ] = AwsError.unwrapOptionField(
      "securityDescriptorCopyFlags",
      securityDescriptorCopyFlags
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.Options
  ) extends zio.aws.datasync.model.Options.ReadOnly {
    override val verifyMode: Optional[zio.aws.datasync.model.VerifyMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifyMode())
        .map(value => zio.aws.datasync.model.VerifyMode.wrap(value))
    override val overwriteMode: Optional[zio.aws.datasync.model.OverwriteMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overwriteMode())
        .map(value => zio.aws.datasync.model.OverwriteMode.wrap(value))
    override val atime: Optional[zio.aws.datasync.model.Atime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.atime())
        .map(value => zio.aws.datasync.model.Atime.wrap(value))
    override val mtime: Optional[zio.aws.datasync.model.Mtime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mtime())
        .map(value => zio.aws.datasync.model.Mtime.wrap(value))
    override val uid: Optional[zio.aws.datasync.model.Uid] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uid())
        .map(value => zio.aws.datasync.model.Uid.wrap(value))
    override val gid: Optional[zio.aws.datasync.model.Gid] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gid())
        .map(value => zio.aws.datasync.model.Gid.wrap(value))
    override val preserveDeletedFiles
        : Optional[zio.aws.datasync.model.PreserveDeletedFiles] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preserveDeletedFiles())
        .map(value => zio.aws.datasync.model.PreserveDeletedFiles.wrap(value))
    override val preserveDevices
        : Optional[zio.aws.datasync.model.PreserveDevices] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preserveDevices())
        .map(value => zio.aws.datasync.model.PreserveDevices.wrap(value))
    override val posixPermissions
        : Optional[zio.aws.datasync.model.PosixPermissions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.posixPermissions())
        .map(value => zio.aws.datasync.model.PosixPermissions.wrap(value))
    override val bytesPerSecond: Optional[BytesPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bytesPerSecond())
        .map(value => zio.aws.datasync.model.primitives.BytesPerSecond(value))
    override val taskQueueing: Optional[zio.aws.datasync.model.TaskQueueing] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskQueueing())
        .map(value => zio.aws.datasync.model.TaskQueueing.wrap(value))
    override val logLevel: Optional[zio.aws.datasync.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevel())
        .map(value => zio.aws.datasync.model.LogLevel.wrap(value))
    override val transferMode: Optional[zio.aws.datasync.model.TransferMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transferMode())
        .map(value => zio.aws.datasync.model.TransferMode.wrap(value))
    override val securityDescriptorCopyFlags
        : Optional[zio.aws.datasync.model.SmbSecurityDescriptorCopyFlags] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityDescriptorCopyFlags())
        .map(value =>
          zio.aws.datasync.model.SmbSecurityDescriptorCopyFlags.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.Options
  ): zio.aws.datasync.model.Options.ReadOnly = new Wrapper(impl)
}
