package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  SmbUser,
  Time,
  LocationArn,
  SmbDomain,
  LocationUri,
  AgentArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeLocationSmbResponse(
    locationArn: Option[LocationArn] = None,
    locationUri: Option[LocationUri] = None,
    agentArns: Option[Iterable[AgentArn]] = None,
    user: Option[SmbUser] = None,
    domain: Option[SmbDomain] = None,
    mountOptions: Option[zio.aws.datasync.model.SmbMountOptions] = None,
    creationTime: Option[Time] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse = {
    import DescribeLocationSmbResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(
        user.map(value => SmbUser.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        domain.map(value => SmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationSmbResponse.wrap(buildAwsValue())
}
object DescribeLocationSmbResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationSmbResponse =
      zio.aws.datasync.model.DescribeLocationSmbResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        agentArns.map(value => value),
        user.map(value => value),
        domain.map(value => value),
        mountOptions.map(value => value.asEditable),
        creationTime.map(value => value)
      )
    def locationArn: Option[LocationArn]
    def locationUri: Option[LocationUri]
    def agentArns: Option[List[AgentArn]]
    def user: Option[SmbUser]
    def domain: Option[SmbDomain]
    def mountOptions: Option[zio.aws.datasync.model.SmbMountOptions.ReadOnly]
    def creationTime: Option[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getUser: ZIO[Any, AwsError, SmbUser] =
      AwsError.unwrapOptionField("user", user)
    def getDomain: ZIO[Any, AwsError, SmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse
  ) extends zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly {
    override val locationArn: Option[LocationArn] = scala
      .Option(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Option[LocationUri] = scala
      .Option(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val agentArns: Option[List[AgentArn]] = scala
      .Option(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val user: Option[SmbUser] = scala
      .Option(impl.user())
      .map(value => zio.aws.datasync.model.primitives.SmbUser(value))
    override val domain: Option[SmbDomain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.SmbDomain(value))
    override val mountOptions
        : Option[zio.aws.datasync.model.SmbMountOptions.ReadOnly] = scala
      .Option(impl.mountOptions())
      .map(value => zio.aws.datasync.model.SmbMountOptions.wrap(value))
    override val creationTime: Option[Time] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationSmbResponse
  ): zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly = new Wrapper(
    impl
  )
}
