package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.AgentArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAgentResponse(agentArn: Option[AgentArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateAgentResponse = {
    import CreateAgentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateAgentResponse
      .builder()
      .optionallyWith(
        agentArn.map(value => AgentArn.unwrap(value): java.lang.String)
      )(_.agentArn)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateAgentResponse.ReadOnly =
    zio.aws.datasync.model.CreateAgentResponse.wrap(buildAwsValue())
}
object CreateAgentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateAgentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateAgentResponse =
      zio.aws.datasync.model.CreateAgentResponse(agentArn.map(value => value))
    def agentArn: Option[AgentArn]
    def getAgentArn: ZIO[Any, AwsError, AgentArn] =
      AwsError.unwrapOptionField("agentArn", agentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateAgentResponse
  ) extends zio.aws.datasync.model.CreateAgentResponse.ReadOnly {
    override val agentArn: Option[AgentArn] = scala
      .Option(impl.agentArn())
      .map(value => zio.aws.datasync.model.primitives.AgentArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateAgentResponse
  ): zio.aws.datasync.model.CreateAgentResponse.ReadOnly = new Wrapper(impl)
}
