package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{ServerHostname, NfsSubdirectory}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLocationNfsRequest(
    subdirectory: NfsSubdirectory,
    serverHostname: ServerHostname,
    onPremConfig: zio.aws.datasync.model.OnPremConfig,
    mountOptions: Option[zio.aws.datasync.model.NfsMountOptions] = None,
    tags: Option[Iterable[zio.aws.datasync.model.TagListEntry]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest = {
    import CreateLocationNfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest
      .builder()
      .subdirectory(NfsSubdirectory.unwrap(subdirectory): java.lang.String)
      .serverHostname(ServerHostname.unwrap(serverHostname): java.lang.String)
      .onPremConfig(onPremConfig.buildAwsValue())
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateLocationNfsRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationNfsRequest.wrap(buildAwsValue())
}
object CreateLocationNfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationNfsRequest =
      zio.aws.datasync.model.CreateLocationNfsRequest(
        subdirectory,
        serverHostname,
        onPremConfig.asEditable,
        mountOptions.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subdirectory: NfsSubdirectory
    def serverHostname: ServerHostname
    def onPremConfig: zio.aws.datasync.model.OnPremConfig.ReadOnly
    def mountOptions: Option[zio.aws.datasync.model.NfsMountOptions.ReadOnly]
    def tags: Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getSubdirectory: ZIO[Any, Nothing, NfsSubdirectory] =
      ZIO.succeed(subdirectory)
    def getServerHostname: ZIO[Any, Nothing, ServerHostname] =
      ZIO.succeed(serverHostname)
    def getOnPremConfig
        : ZIO[Any, Nothing, zio.aws.datasync.model.OnPremConfig.ReadOnly] =
      ZIO.succeed(onPremConfig)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.NfsMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest
  ) extends zio.aws.datasync.model.CreateLocationNfsRequest.ReadOnly {
    override val subdirectory: NfsSubdirectory =
      zio.aws.datasync.model.primitives.NfsSubdirectory(impl.subdirectory())
    override val serverHostname: ServerHostname =
      zio.aws.datasync.model.primitives.ServerHostname(impl.serverHostname())
    override val onPremConfig: zio.aws.datasync.model.OnPremConfig.ReadOnly =
      zio.aws.datasync.model.OnPremConfig.wrap(impl.onPremConfig())
    override val mountOptions
        : Option[zio.aws.datasync.model.NfsMountOptions.ReadOnly] = scala
      .Option(impl.mountOptions())
      .map(value => zio.aws.datasync.model.NfsMountOptions.wrap(value))
    override val tags
        : Option[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.TagListEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest
  ): zio.aws.datasync.model.CreateLocationNfsRequest.ReadOnly = new Wrapper(
    impl
  )
}
