package zio.aws.datasync.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Time,
  ObjectStorageServerPort,
  ObjectStorageAccessKey,
  LocationArn,
  LocationUri,
  AgentArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeLocationObjectStorageResponse(
    locationArn: Option[LocationArn] = None,
    locationUri: Option[LocationUri] = None,
    accessKey: Option[ObjectStorageAccessKey] = None,
    serverPort: Option[ObjectStorageServerPort] = None,
    serverProtocol: Option[zio.aws.datasync.model.ObjectStorageServerProtocol] =
      None,
    agentArns: Option[Iterable[AgentArn]] = None,
    creationTime: Option[Time] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse = {
    import DescribeLocationObjectStorageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        accessKey.map(value =>
          ObjectStorageAccessKey.unwrap(value): java.lang.String
        )
      )(_.accessKey)
      .optionallyWith(
        serverPort.map(value => ObjectStorageServerPort.unwrap(value): Integer)
      )(_.serverPort)
      .optionallyWith(serverProtocol.map(value => value.unwrap))(
        _.serverProtocol
      )
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationObjectStorageResponse
      .wrap(buildAwsValue())
}
object DescribeLocationObjectStorageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datasync.model.DescribeLocationObjectStorageResponse =
      zio.aws.datasync.model.DescribeLocationObjectStorageResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        accessKey.map(value => value),
        serverPort.map(value => value),
        serverProtocol.map(value => value),
        agentArns.map(value => value),
        creationTime.map(value => value)
      )
    def locationArn: Option[LocationArn]
    def locationUri: Option[LocationUri]
    def accessKey: Option[ObjectStorageAccessKey]
    def serverPort: Option[ObjectStorageServerPort]
    def serverProtocol
        : Option[zio.aws.datasync.model.ObjectStorageServerProtocol]
    def agentArns: Option[List[AgentArn]]
    def creationTime: Option[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getAccessKey: ZIO[Any, AwsError, ObjectStorageAccessKey] =
      AwsError.unwrapOptionField("accessKey", accessKey)
    def getServerPort: ZIO[Any, AwsError, ObjectStorageServerPort] =
      AwsError.unwrapOptionField("serverPort", serverPort)
    def getServerProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.ObjectStorageServerProtocol
    ] = AwsError.unwrapOptionField("serverProtocol", serverProtocol)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse
  ) extends zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly {
    override val locationArn: Option[LocationArn] = scala
      .Option(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Option[LocationUri] = scala
      .Option(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val accessKey: Option[ObjectStorageAccessKey] = scala
      .Option(impl.accessKey())
      .map(value =>
        zio.aws.datasync.model.primitives.ObjectStorageAccessKey(value)
      )
    override val serverPort: Option[ObjectStorageServerPort] = scala
      .Option(impl.serverPort())
      .map(value =>
        zio.aws.datasync.model.primitives.ObjectStorageServerPort(value)
      )
    override val serverProtocol
        : Option[zio.aws.datasync.model.ObjectStorageServerProtocol] = scala
      .Option(impl.serverProtocol())
      .map(value =>
        zio.aws.datasync.model.ObjectStorageServerProtocol.wrap(value)
      )
    override val agentArns: Option[List[AgentArn]] = scala
      .Option(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val creationTime: Option[Time] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageResponse
  ): zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly =
    new Wrapper(impl)
}
