package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  SmbUser,
  SmbSubdirectory,
  SmbPassword,
  LocationArn,
  SmbDomain,
  AgentArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateLocationSmbRequest(
    locationArn: LocationArn,
    subdirectory: Option[SmbSubdirectory] = None,
    user: Option[SmbUser] = None,
    domain: Option[SmbDomain] = None,
    password: Option[SmbPassword] = None,
    agentArns: Option[Iterable[AgentArn]] = None,
    mountOptions: Option[zio.aws.datasync.model.SmbMountOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest = {
    import UpdateLocationSmbRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        subdirectory.map(value =>
          SmbSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(
        user.map(value => SmbUser.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        domain.map(value => SmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        password.map(value => SmbPassword.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateLocationSmbRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationSmbRequest.wrap(buildAwsValue())
}
object UpdateLocationSmbRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationSmbRequest =
      zio.aws.datasync.model.UpdateLocationSmbRequest(
        locationArn,
        subdirectory.map(value => value),
        user.map(value => value),
        domain.map(value => value),
        password.map(value => value),
        agentArns.map(value => value),
        mountOptions.map(value => value.asEditable)
      )
    def locationArn: LocationArn
    def subdirectory: Option[SmbSubdirectory]
    def user: Option[SmbUser]
    def domain: Option[SmbDomain]
    def password: Option[SmbPassword]
    def agentArns: Option[List[AgentArn]]
    def mountOptions: Option[zio.aws.datasync.model.SmbMountOptions.ReadOnly]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getSubdirectory: ZIO[Any, AwsError, SmbSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getUser: ZIO[Any, AwsError, SmbUser] =
      AwsError.unwrapOptionField("user", user)
    def getDomain: ZIO[Any, AwsError, SmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getPassword: ZIO[Any, AwsError, SmbPassword] =
      AwsError.unwrapOptionField("password", password)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest
  ) extends zio.aws.datasync.model.UpdateLocationSmbRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val subdirectory: Option[SmbSubdirectory] = scala
      .Option(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.SmbSubdirectory(value))
    override val user: Option[SmbUser] = scala
      .Option(impl.user())
      .map(value => zio.aws.datasync.model.primitives.SmbUser(value))
    override val domain: Option[SmbDomain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.SmbDomain(value))
    override val password: Option[SmbPassword] = scala
      .Option(impl.password())
      .map(value => zio.aws.datasync.model.primitives.SmbPassword(value))
    override val agentArns: Option[List[AgentArn]] = scala
      .Option(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val mountOptions
        : Option[zio.aws.datasync.model.SmbMountOptions.ReadOnly] = scala
      .Option(impl.mountOptions())
      .map(value => zio.aws.datasync.model.SmbMountOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest
  ): zio.aws.datasync.model.UpdateLocationSmbRequest.ReadOnly = new Wrapper(
    impl
  )
}
