package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{TagValue, AgentArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAgentRequest(
    agentArn: AgentArn,
    name: Option[TagValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateAgentRequest = {
    import UpdateAgentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateAgentRequest
      .builder()
      .agentArn(AgentArn.unwrap(agentArn): java.lang.String)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateAgentRequest.ReadOnly =
    zio.aws.datasync.model.UpdateAgentRequest.wrap(buildAwsValue())
}
object UpdateAgentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateAgentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateAgentRequest =
      zio.aws.datasync.model
        .UpdateAgentRequest(agentArn, name.map(value => value))
    def agentArn: AgentArn
    def name: Option[TagValue]
    def getAgentArn: ZIO[Any, Nothing, AgentArn] = ZIO.succeed(agentArn)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateAgentRequest
  ) extends zio.aws.datasync.model.UpdateAgentRequest.ReadOnly {
    override val agentArn: AgentArn =
      zio.aws.datasync.model.primitives.AgentArn(impl.agentArn())
    override val name: Option[TagValue] = scala
      .Option(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateAgentRequest
  ): zio.aws.datasync.model.UpdateAgentRequest.ReadOnly = new Wrapper(impl)
}
