package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait S3StorageClass {
  def unwrap: software.amazon.awssdk.services.datasync.model.S3StorageClass
}
object S3StorageClass {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.S3StorageClass
  ): zio.aws.datasync.model.S3StorageClass = value match {
    case software.amazon.awssdk.services.datasync.model.S3StorageClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.S3StorageClass.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.datasync.model.S3StorageClass.STANDARD_IA =>
      val r = STANDARD_IA
      r
    case software.amazon.awssdk.services.datasync.model.S3StorageClass.ONEZONE_IA =>
      val r = ONEZONE_IA
      r
    case software.amazon.awssdk.services.datasync.model.S3StorageClass.INTELLIGENT_TIERING =>
      val r = INTELLIGENT_TIERING
      r
    case software.amazon.awssdk.services.datasync.model.S3StorageClass.GLACIER =>
      val r = GLACIER
      r
    case software.amazon.awssdk.services.datasync.model.S3StorageClass.DEEP_ARCHIVE =>
      val r = DEEP_ARCHIVE
      r
    case software.amazon.awssdk.services.datasync.model.S3StorageClass.OUTPOSTS =>
      val r = OUTPOSTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.S3StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.S3StorageClass =
      software.amazon.awssdk.services.datasync.model.S3StorageClass.UNKNOWN_TO_SDK_VERSION
  }
  case object STANDARD extends zio.aws.datasync.model.S3StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.S3StorageClass =
      software.amazon.awssdk.services.datasync.model.S3StorageClass.STANDARD
  }
  case object STANDARD_IA extends zio.aws.datasync.model.S3StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.S3StorageClass =
      software.amazon.awssdk.services.datasync.model.S3StorageClass.STANDARD_IA
  }
  case object ONEZONE_IA extends zio.aws.datasync.model.S3StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.S3StorageClass =
      software.amazon.awssdk.services.datasync.model.S3StorageClass.ONEZONE_IA
  }
  case object INTELLIGENT_TIERING
      extends zio.aws.datasync.model.S3StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.S3StorageClass =
      software.amazon.awssdk.services.datasync.model.S3StorageClass.INTELLIGENT_TIERING
  }
  case object GLACIER extends zio.aws.datasync.model.S3StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.S3StorageClass =
      software.amazon.awssdk.services.datasync.model.S3StorageClass.GLACIER
  }
  case object DEEP_ARCHIVE extends zio.aws.datasync.model.S3StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.S3StorageClass =
      software.amazon.awssdk.services.datasync.model.S3StorageClass.DEEP_ARCHIVE
  }
  case object OUTPOSTS extends zio.aws.datasync.model.S3StorageClass {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.S3StorageClass =
      software.amazon.awssdk.services.datasync.model.S3StorageClass.OUTPOSTS
  }
}
