package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait PosixPermissions {
  def unwrap: software.amazon.awssdk.services.datasync.model.PosixPermissions
}
object PosixPermissions {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.PosixPermissions
  ): zio.aws.datasync.model.PosixPermissions = value match {
    case software.amazon.awssdk.services.datasync.model.PosixPermissions.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.PosixPermissions.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.datasync.model.PosixPermissions.PRESERVE =>
      val r = PRESERVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.PosixPermissions {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PosixPermissions =
      software.amazon.awssdk.services.datasync.model.PosixPermissions.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.datasync.model.PosixPermissions {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PosixPermissions =
      software.amazon.awssdk.services.datasync.model.PosixPermissions.NONE
  }
  case object PRESERVE extends zio.aws.datasync.model.PosixPermissions {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PosixPermissions =
      software.amazon.awssdk.services.datasync.model.PosixPermissions.PRESERVE
  }
}
