package zio.aws.datasync.model
import java.lang.Integer
import zio.aws.datasync.model.primitives.{
  ObjectStorageServerPort,
  ObjectStorageAccessKey,
  LocationArn,
  ObjectStorageSecretKey,
  S3Subdirectory,
  AgentArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateLocationObjectStorageRequest(
    locationArn: LocationArn,
    serverPort: Option[ObjectStorageServerPort] = None,
    serverProtocol: Option[zio.aws.datasync.model.ObjectStorageServerProtocol] =
      None,
    subdirectory: Option[S3Subdirectory] = None,
    accessKey: Option[ObjectStorageAccessKey] = None,
    secretKey: Option[ObjectStorageSecretKey] = None,
    agentArns: Option[Iterable[AgentArn]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest = {
    import UpdateLocationObjectStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        serverPort.map(value => ObjectStorageServerPort.unwrap(value): Integer)
      )(_.serverPort)
      .optionallyWith(serverProtocol.map(value => value.unwrap))(
        _.serverProtocol
      )
      .optionallyWith(
        subdirectory.map(value =>
          S3Subdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(
        accessKey.map(value =>
          ObjectStorageAccessKey.unwrap(value): java.lang.String
        )
      )(_.accessKey)
      .optionallyWith(
        secretKey.map(value =>
          ObjectStorageSecretKey.unwrap(value): java.lang.String
        )
      )(_.secretKey)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.UpdateLocationObjectStorageRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationObjectStorageRequest
      .wrap(buildAwsValue())
}
object UpdateLocationObjectStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationObjectStorageRequest =
      zio.aws.datasync.model.UpdateLocationObjectStorageRequest(
        locationArn,
        serverPort.map(value => value),
        serverProtocol.map(value => value),
        subdirectory.map(value => value),
        accessKey.map(value => value),
        secretKey.map(value => value),
        agentArns.map(value => value)
      )
    def locationArn: LocationArn
    def serverPort: Option[ObjectStorageServerPort]
    def serverProtocol
        : Option[zio.aws.datasync.model.ObjectStorageServerProtocol]
    def subdirectory: Option[S3Subdirectory]
    def accessKey: Option[ObjectStorageAccessKey]
    def secretKey: Option[ObjectStorageSecretKey]
    def agentArns: Option[List[AgentArn]]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getServerPort: ZIO[Any, AwsError, ObjectStorageServerPort] =
      AwsError.unwrapOptionField("serverPort", serverPort)
    def getServerProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.ObjectStorageServerProtocol
    ] = AwsError.unwrapOptionField("serverProtocol", serverProtocol)
    def getSubdirectory: ZIO[Any, AwsError, S3Subdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getAccessKey: ZIO[Any, AwsError, ObjectStorageAccessKey] =
      AwsError.unwrapOptionField("accessKey", accessKey)
    def getSecretKey: ZIO[Any, AwsError, ObjectStorageSecretKey] =
      AwsError.unwrapOptionField("secretKey", secretKey)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest
  ) extends zio.aws.datasync.model.UpdateLocationObjectStorageRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val serverPort: Option[ObjectStorageServerPort] = scala
      .Option(impl.serverPort())
      .map(value =>
        zio.aws.datasync.model.primitives.ObjectStorageServerPort(value)
      )
    override val serverProtocol
        : Option[zio.aws.datasync.model.ObjectStorageServerProtocol] = scala
      .Option(impl.serverProtocol())
      .map(value =>
        zio.aws.datasync.model.ObjectStorageServerProtocol.wrap(value)
      )
    override val subdirectory: Option[S3Subdirectory] = scala
      .Option(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.S3Subdirectory(value))
    override val accessKey: Option[ObjectStorageAccessKey] = scala
      .Option(impl.accessKey())
      .map(value =>
        zio.aws.datasync.model.primitives.ObjectStorageAccessKey(value)
      )
    override val secretKey: Option[ObjectStorageSecretKey] = scala
      .Option(impl.secretKey())
      .map(value =>
        zio.aws.datasync.model.primitives.ObjectStorageSecretKey(value)
      )
    override val agentArns: Option[List[AgentArn]] = scala
      .Option(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest
  ): zio.aws.datasync.model.UpdateLocationObjectStorageRequest.ReadOnly =
    new Wrapper(impl)
}
