package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait StorageSystemConnectivityStatus {
  def unwrap: software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus
}
object StorageSystemConnectivityStatus {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus
  ): zio.aws.datasync.model.StorageSystemConnectivityStatus = value match {
    case software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus.PASS =>
      val r = PASS
      r
    case software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus.FAIL =>
      val r = FAIL
      r
    case software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.StorageSystemConnectivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus =
      software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PASS
      extends zio.aws.datasync.model.StorageSystemConnectivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus =
      software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus.PASS
  }
  case object FAIL
      extends zio.aws.datasync.model.StorageSystemConnectivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus =
      software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus.FAIL
  }
  case object UNKNOWN
      extends zio.aws.datasync.model.StorageSystemConnectivityStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus =
      software.amazon.awssdk.services.datasync.model.StorageSystemConnectivityStatus.UNKNOWN
  }
}
