package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.PtolemyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Recommendation(
    storageType: Optional[PtolemyString] = Optional.Absent,
    storageConfiguration: Optional[Map[PtolemyString, PtolemyString]] =
      Optional.Absent,
    estimatedMonthlyStorageCost: Optional[PtolemyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.Recommendation = {
    import Recommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.Recommendation
      .builder()
      .optionallyWith(
        storageType.map(value => PtolemyString.unwrap(value): java.lang.String)
      )(_.storageType)
      .optionallyWith(
        storageConfiguration.map(value =>
          value
            .map({ case (key, value) =>
              (PtolemyString.unwrap(key): java.lang.String) -> (PtolemyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.storageConfiguration)
      .optionallyWith(
        estimatedMonthlyStorageCost.map(value =>
          PtolemyString.unwrap(value): java.lang.String
        )
      )(_.estimatedMonthlyStorageCost)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.Recommendation.ReadOnly =
    zio.aws.datasync.model.Recommendation.wrap(buildAwsValue())
}
object Recommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.Recommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.Recommendation =
      zio.aws.datasync.model.Recommendation(
        storageType.map(value => value),
        storageConfiguration.map(value => value),
        estimatedMonthlyStorageCost.map(value => value)
      )
    def storageType: Optional[PtolemyString]
    def storageConfiguration: Optional[Map[PtolemyString, PtolemyString]]
    def estimatedMonthlyStorageCost: Optional[PtolemyString]
    def getStorageType: ZIO[Any, AwsError, PtolemyString] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getStorageConfiguration
        : ZIO[Any, AwsError, Map[PtolemyString, PtolemyString]] =
      AwsError.unwrapOptionField("storageConfiguration", storageConfiguration)
    def getEstimatedMonthlyStorageCost: ZIO[Any, AwsError, PtolemyString] =
      AwsError.unwrapOptionField(
        "estimatedMonthlyStorageCost",
        estimatedMonthlyStorageCost
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.Recommendation
  ) extends zio.aws.datasync.model.Recommendation.ReadOnly {
    override val storageType: Optional[PtolemyString] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => zio.aws.datasync.model.primitives.PtolemyString(value))
    override val storageConfiguration
        : Optional[Map[PtolemyString, PtolemyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.storageConfiguration())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.datasync.model.primitives.PtolemyString(
              key
            ) -> zio.aws.datasync.model.primitives.PtolemyString(value)
          })
          .toMap
      )
    override val estimatedMonthlyStorageCost: Optional[PtolemyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedMonthlyStorageCost())
        .map(value => zio.aws.datasync.model.primitives.PtolemyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.Recommendation
  ): zio.aws.datasync.model.Recommendation.ReadOnly = new Wrapper(impl)
}
