package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{ResourceId, DiscoveryJobArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GenerateRecommendationsRequest(
    discoveryJobArn: DiscoveryJobArn,
    resourceIds: Iterable[ResourceId],
    resourceType: zio.aws.datasync.model.DiscoveryResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.GenerateRecommendationsRequest = {
    import GenerateRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.GenerateRecommendationsRequest
      .builder()
      .discoveryJobArn(
        DiscoveryJobArn.unwrap(discoveryJobArn): java.lang.String
      )
      .resourceIds(resourceIds.map { item =>
        ResourceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .resourceType(resourceType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.GenerateRecommendationsRequest.ReadOnly =
    zio.aws.datasync.model.GenerateRecommendationsRequest.wrap(buildAwsValue())
}
object GenerateRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.GenerateRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.GenerateRecommendationsRequest =
      zio.aws.datasync.model.GenerateRecommendationsRequest(
        discoveryJobArn,
        resourceIds,
        resourceType
      )
    def discoveryJobArn: DiscoveryJobArn
    def resourceIds: List[ResourceId]
    def resourceType: zio.aws.datasync.model.DiscoveryResourceType
    def getDiscoveryJobArn: ZIO[Any, Nothing, DiscoveryJobArn] =
      ZIO.succeed(discoveryJobArn)
    def getResourceIds: ZIO[Any, Nothing, List[ResourceId]] =
      ZIO.succeed(resourceIds)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.datasync.model.DiscoveryResourceType] =
      ZIO.succeed(resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.GenerateRecommendationsRequest
  ) extends zio.aws.datasync.model.GenerateRecommendationsRequest.ReadOnly {
    override val discoveryJobArn: DiscoveryJobArn =
      zio.aws.datasync.model.primitives.DiscoveryJobArn(impl.discoveryJobArn())
    override val resourceIds: List[ResourceId] = impl
      .resourceIds()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.ResourceId(item)
      }
      .toList
    override val resourceType: zio.aws.datasync.model.DiscoveryResourceType =
      zio.aws.datasync.model.DiscoveryResourceType.wrap(impl.resourceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.GenerateRecommendationsRequest
  ): zio.aws.datasync.model.GenerateRecommendationsRequest.ReadOnly =
    new Wrapper(impl)
}
