package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait PreserveDeletedFiles {
  def unwrap
      : software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles
}
object PreserveDeletedFiles {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles
  ): zio.aws.datasync.model.PreserveDeletedFiles = value match {
    case software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles.PRESERVE =>
      val r = PRESERVE
      r
    case software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles.REMOVE =>
      val r = REMOVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.PreserveDeletedFiles {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles =
      software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles.UNKNOWN_TO_SDK_VERSION
  }
  case object PRESERVE extends zio.aws.datasync.model.PreserveDeletedFiles {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles =
      software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles.PRESERVE
  }
  case object REMOVE extends zio.aws.datasync.model.PreserveDeletedFiles {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles =
      software.amazon.awssdk.services.datasync.model.PreserveDeletedFiles.REMOVE
  }
}
