package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.StorageSystemArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddStorageSystemResponse(storageSystemArn: StorageSystemArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.AddStorageSystemResponse = {
    import AddStorageSystemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.AddStorageSystemResponse
      .builder()
      .storageSystemArn(
        StorageSystemArn.unwrap(storageSystemArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.AddStorageSystemResponse.ReadOnly =
    zio.aws.datasync.model.AddStorageSystemResponse.wrap(buildAwsValue())
}
object AddStorageSystemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.AddStorageSystemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.AddStorageSystemResponse =
      zio.aws.datasync.model.AddStorageSystemResponse(storageSystemArn)
    def storageSystemArn: StorageSystemArn
    def getStorageSystemArn: ZIO[Any, Nothing, StorageSystemArn] =
      ZIO.succeed(storageSystemArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.AddStorageSystemResponse
  ) extends zio.aws.datasync.model.AddStorageSystemResponse.ReadOnly {
    override val storageSystemArn: StorageSystemArn =
      zio.aws.datasync.model.primitives
        .StorageSystemArn(impl.storageSystemArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.AddStorageSystemResponse
  ): zio.aws.datasync.model.AddStorageSystemResponse.ReadOnly = new Wrapper(
    impl
  )
}
