package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{LogGroupArn, TagValue, TaskArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateTaskRequest(
    taskArn: TaskArn,
    options: Optional[zio.aws.datasync.model.Options] = Optional.Absent,
    excludes: Optional[Iterable[zio.aws.datasync.model.FilterRule]] =
      Optional.Absent,
    schedule: Optional[zio.aws.datasync.model.TaskSchedule] = Optional.Absent,
    name: Optional[TagValue] = Optional.Absent,
    cloudWatchLogGroupArn: Optional[LogGroupArn] = Optional.Absent,
    includes: Optional[Iterable[zio.aws.datasync.model.FilterRule]] =
      Optional.Absent,
    taskReportConfig: Optional[zio.aws.datasync.model.TaskReportConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateTaskRequest = {
    import UpdateTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateTaskRequest
      .builder()
      .taskArn(TaskArn.unwrap(taskArn): java.lang.String)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          LogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .optionallyWith(taskReportConfig.map(value => value.buildAwsValue()))(
        _.taskReportConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateTaskRequest.ReadOnly =
    zio.aws.datasync.model.UpdateTaskRequest.wrap(buildAwsValue())
}
object UpdateTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateTaskRequest =
      zio.aws.datasync.model.UpdateTaskRequest(
        taskArn,
        options.map(value => value.asEditable),
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schedule.map(value => value.asEditable),
        name.map(value => value),
        cloudWatchLogGroupArn.map(value => value),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskReportConfig.map(value => value.asEditable)
      )
    def taskArn: TaskArn
    def options: Optional[zio.aws.datasync.model.Options.ReadOnly]
    def excludes: Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def schedule: Optional[zio.aws.datasync.model.TaskSchedule.ReadOnly]
    def name: Optional[TagValue]
    def cloudWatchLogGroupArn: Optional[LogGroupArn]
    def includes: Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def taskReportConfig
        : Optional[zio.aws.datasync.model.TaskReportConfig.ReadOnly]
    def getTaskArn: ZIO[Any, Nothing, TaskArn] = ZIO.succeed(taskArn)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.Options.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getExcludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludes", excludes)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskSchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, LogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getIncludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("includes", includes)
    def getTaskReportConfig
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskReportConfig.ReadOnly] =
      AwsError.unwrapOptionField("taskReportConfig", taskReportConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateTaskRequest
  ) extends zio.aws.datasync.model.UpdateTaskRequest.ReadOnly {
    override val taskArn: TaskArn =
      zio.aws.datasync.model.primitives.TaskArn(impl.taskArn())
    override val options: Optional[zio.aws.datasync.model.Options.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.datasync.model.Options.wrap(value))
    override val excludes
        : Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.FilterRule.wrap(item)
          }.toList
        )
    override val schedule
        : Optional[zio.aws.datasync.model.TaskSchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.datasync.model.TaskSchedule.wrap(value))
    override val name: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val cloudWatchLogGroupArn: Optional[LogGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupArn())
        .map(value => zio.aws.datasync.model.primitives.LogGroupArn(value))
    override val includes
        : Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.FilterRule.wrap(item)
          }.toList
        )
    override val taskReportConfig
        : Optional[zio.aws.datasync.model.TaskReportConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskReportConfig())
        .map(value => zio.aws.datasync.model.TaskReportConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateTaskRequest
  ): zio.aws.datasync.model.UpdateTaskRequest.ReadOnly = new Wrapper(impl)
}
