package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{TagValue, AgentArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AgentListEntry(
    agentArn: Optional[AgentArn] = Optional.Absent,
    name: Optional[TagValue] = Optional.Absent,
    status: Optional[zio.aws.datasync.model.AgentStatus] = Optional.Absent,
    platform: Optional[zio.aws.datasync.model.Platform] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.AgentListEntry = {
    import AgentListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.AgentListEntry
      .builder()
      .optionallyWith(
        agentArn.map(value => AgentArn.unwrap(value): java.lang.String)
      )(_.agentArn)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(platform.map(value => value.buildAwsValue()))(_.platform)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.AgentListEntry.ReadOnly =
    zio.aws.datasync.model.AgentListEntry.wrap(buildAwsValue())
}
object AgentListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.AgentListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.AgentListEntry =
      zio.aws.datasync.model.AgentListEntry(
        agentArn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        platform.map(value => value.asEditable)
      )
    def agentArn: Optional[AgentArn]
    def name: Optional[TagValue]
    def status: Optional[zio.aws.datasync.model.AgentStatus]
    def platform: Optional[zio.aws.datasync.model.Platform.ReadOnly]
    def getAgentArn: ZIO[Any, AwsError, AgentArn] =
      AwsError.unwrapOptionField("agentArn", agentArn)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.datasync.model.AgentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.datasync.model.Platform.ReadOnly] =
      AwsError.unwrapOptionField("platform", platform)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.AgentListEntry
  ) extends zio.aws.datasync.model.AgentListEntry.ReadOnly {
    override val agentArn: Optional[AgentArn] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArn())
      .map(value => zio.aws.datasync.model.primitives.AgentArn(value))
    override val name: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val status: Optional[zio.aws.datasync.model.AgentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datasync.model.AgentStatus.wrap(value))
    override val platform: Optional[zio.aws.datasync.model.Platform.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.datasync.model.Platform.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.AgentListEntry
  ): zio.aws.datasync.model.AgentListEntry.ReadOnly = new Wrapper(impl)
}
