package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReportDestination(
    s3: Optional[zio.aws.datasync.model.ReportDestinationS3] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ReportDestination = {
    import ReportDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ReportDestination
      .builder()
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ReportDestination.ReadOnly =
    zio.aws.datasync.model.ReportDestination.wrap(buildAwsValue())
}
object ReportDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ReportDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ReportDestination =
      zio.aws.datasync.model
        .ReportDestination(s3.map(value => value.asEditable))
    def s3: Optional[zio.aws.datasync.model.ReportDestinationS3.ReadOnly]
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.ReportDestinationS3.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ReportDestination
  ) extends zio.aws.datasync.model.ReportDestination.ReadOnly {
    override val s3
        : Optional[zio.aws.datasync.model.ReportDestinationS3.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.datasync.model.ReportDestinationS3.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ReportDestination
  ): zio.aws.datasync.model.ReportDestination.ReadOnly = new Wrapper(impl)
}
