package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocationAzureBlobResponse(
    locationArn: Optional[LocationArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobResponse = {
    import CreateLocationAzureBlobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationAzureBlobResponse.ReadOnly =
    zio.aws.datasync.model.CreateLocationAzureBlobResponse.wrap(buildAwsValue())
}
object CreateLocationAzureBlobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationAzureBlobResponse =
      zio.aws.datasync.model
        .CreateLocationAzureBlobResponse(locationArn.map(value => value))
    def locationArn: Optional[LocationArn]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobResponse
  ) extends zio.aws.datasync.model.CreateLocationAzureBlobResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobResponse
  ): zio.aws.datasync.model.CreateLocationAzureBlobResponse.ReadOnly =
    new Wrapper(impl)
}
