package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{ResourceId, Timestamp}
import scala.jdk.CollectionConverters._
final case class ResourceMetrics(
    timestamp: Optional[Timestamp] = Optional.Absent,
    p95Metrics: Optional[zio.aws.datasync.model.P95Metrics] = Optional.Absent,
    capacity: Optional[zio.aws.datasync.model.Capacity] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent,
    resourceType: Optional[zio.aws.datasync.model.DiscoveryResourceType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ResourceMetrics = {
    import ResourceMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ResourceMetrics
      .builder()
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(p95Metrics.map(value => value.buildAwsValue()))(
        _.p95Metrics
      )
      .optionallyWith(capacity.map(value => value.buildAwsValue()))(_.capacity)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ResourceMetrics.ReadOnly =
    zio.aws.datasync.model.ResourceMetrics.wrap(buildAwsValue())
}
object ResourceMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ResourceMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ResourceMetrics =
      zio.aws.datasync.model.ResourceMetrics(
        timestamp.map(value => value),
        p95Metrics.map(value => value.asEditable),
        capacity.map(value => value.asEditable),
        resourceId.map(value => value),
        resourceType.map(value => value)
      )
    def timestamp: Optional[Timestamp]
    def p95Metrics: Optional[zio.aws.datasync.model.P95Metrics.ReadOnly]
    def capacity: Optional[zio.aws.datasync.model.Capacity.ReadOnly]
    def resourceId: Optional[ResourceId]
    def resourceType: Optional[zio.aws.datasync.model.DiscoveryResourceType]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getP95Metrics
        : ZIO[Any, AwsError, zio.aws.datasync.model.P95Metrics.ReadOnly] =
      AwsError.unwrapOptionField("p95Metrics", p95Metrics)
    def getCapacity
        : ZIO[Any, AwsError, zio.aws.datasync.model.Capacity.ReadOnly] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.datasync.model.DiscoveryResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ResourceMetrics
  ) extends zio.aws.datasync.model.ResourceMetrics.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.datasync.model.primitives.Timestamp(value))
    override val p95Metrics
        : Optional[zio.aws.datasync.model.P95Metrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.p95Metrics())
        .map(value => zio.aws.datasync.model.P95Metrics.wrap(value))
    override val capacity: Optional[zio.aws.datasync.model.Capacity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacity())
        .map(value => zio.aws.datasync.model.Capacity.wrap(value))
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.datasync.model.primitives.ResourceId(value))
    override val resourceType
        : Optional[zio.aws.datasync.model.DiscoveryResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.datasync.model.DiscoveryResourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ResourceMetrics
  ): zio.aws.datasync.model.ResourceMetrics.ReadOnly = new Wrapper(impl)
}
