package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  LogGroupArn,
  Name,
  AgentArn,
  StorageSystemArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStorageSystemRequest(
    storageSystemArn: StorageSystemArn,
    serverConfiguration: Optional[
      zio.aws.datasync.model.DiscoveryServerConfiguration
    ] = Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    cloudWatchLogGroupArn: Optional[LogGroupArn] = Optional.Absent,
    credentials: Optional[zio.aws.datasync.model.Credentials] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateStorageSystemRequest = {
    import UpdateStorageSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateStorageSystemRequest
      .builder()
      .storageSystemArn(
        StorageSystemArn.unwrap(storageSystemArn): java.lang.String
      )
      .optionallyWith(serverConfiguration.map(value => value.buildAwsValue()))(
        _.serverConfiguration
      )
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          LogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateStorageSystemRequest.ReadOnly =
    zio.aws.datasync.model.UpdateStorageSystemRequest.wrap(buildAwsValue())
}
object UpdateStorageSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateStorageSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateStorageSystemRequest =
      zio.aws.datasync.model.UpdateStorageSystemRequest(
        storageSystemArn,
        serverConfiguration.map(value => value.asEditable),
        agentArns.map(value => value),
        name.map(value => value),
        cloudWatchLogGroupArn.map(value => value),
        credentials.map(value => value.asEditable)
      )
    def storageSystemArn: StorageSystemArn
    def serverConfiguration
        : Optional[zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly]
    def agentArns: Optional[List[AgentArn]]
    def name: Optional[Name]
    def cloudWatchLogGroupArn: Optional[LogGroupArn]
    def credentials: Optional[zio.aws.datasync.model.Credentials.ReadOnly]
    def getStorageSystemArn: ZIO[Any, Nothing, StorageSystemArn] =
      ZIO.succeed(storageSystemArn)
    def getServerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("serverConfiguration", serverConfiguration)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, LogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.datasync.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateStorageSystemRequest
  ) extends zio.aws.datasync.model.UpdateStorageSystemRequest.ReadOnly {
    override val storageSystemArn: StorageSystemArn =
      zio.aws.datasync.model.primitives
        .StorageSystemArn(impl.storageSystemArn())
    override val serverConfiguration: Optional[
      zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverConfiguration())
      .map(value =>
        zio.aws.datasync.model.DiscoveryServerConfiguration.wrap(value)
      )
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datasync.model.primitives.Name(value))
    override val cloudWatchLogGroupArn: Optional[LogGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupArn())
        .map(value => zio.aws.datasync.model.primitives.LogGroupArn(value))
    override val credentials
        : Optional[zio.aws.datasync.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.datasync.model.Credentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateStorageSystemRequest
  ): zio.aws.datasync.model.UpdateStorageSystemRequest.ReadOnly = new Wrapper(
    impl
  )
}
