package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  DiscoveryNextToken,
  DiscoveryMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStorageSystemsRequest(
    maxResults: Optional[DiscoveryMaxResults] = Optional.Absent,
    nextToken: Optional[DiscoveryNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest = {
    import ListStorageSystemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => DiscoveryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          DiscoveryNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListStorageSystemsRequest.ReadOnly =
    zio.aws.datasync.model.ListStorageSystemsRequest.wrap(buildAwsValue())
}
object ListStorageSystemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListStorageSystemsRequest =
      zio.aws.datasync.model.ListStorageSystemsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[DiscoveryMaxResults]
    def nextToken: Optional[DiscoveryNextToken]
    def getMaxResults: ZIO[Any, AwsError, DiscoveryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, DiscoveryNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest
  ) extends zio.aws.datasync.model.ListStorageSystemsRequest.ReadOnly {
    override val maxResults: Optional[DiscoveryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.datasync.model.primitives.DiscoveryMaxResults(value)
        )
    override val nextToken: Optional[DiscoveryNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest
  ): zio.aws.datasync.model.ListStorageSystemsRequest.ReadOnly = new Wrapper(
    impl
  )
}
