package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaskExecutionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateTaskExecutionRequest(
    taskExecutionArn: TaskExecutionArn,
    options: zio.aws.datasync.model.Options
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionRequest = {
    import UpdateTaskExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionRequest
      .builder()
      .taskExecutionArn(
        TaskExecutionArn.unwrap(taskExecutionArn): java.lang.String
      )
      .options(options.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateTaskExecutionRequest.ReadOnly =
    zio.aws.datasync.model.UpdateTaskExecutionRequest.wrap(buildAwsValue())
}
object UpdateTaskExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateTaskExecutionRequest =
      zio.aws.datasync.model
        .UpdateTaskExecutionRequest(taskExecutionArn, options.asEditable)
    def taskExecutionArn: TaskExecutionArn
    def options: zio.aws.datasync.model.Options.ReadOnly
    def getTaskExecutionArn: ZIO[Any, Nothing, TaskExecutionArn] =
      ZIO.succeed(taskExecutionArn)
    def getOptions: ZIO[Any, Nothing, zio.aws.datasync.model.Options.ReadOnly] =
      ZIO.succeed(options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionRequest
  ) extends zio.aws.datasync.model.UpdateTaskExecutionRequest.ReadOnly {
    override val taskExecutionArn: TaskExecutionArn =
      zio.aws.datasync.model.primitives
        .TaskExecutionArn(impl.taskExecutionArn())
    override val options: zio.aws.datasync.model.Options.ReadOnly =
      zio.aws.datasync.model.Options.wrap(impl.options())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionRequest
  ): zio.aws.datasync.model.UpdateTaskExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
