package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskReportConfig(
    destination: Optional[zio.aws.datasync.model.ReportDestination] =
      Optional.Absent,
    outputType: Optional[zio.aws.datasync.model.ReportOutputType] =
      Optional.Absent,
    reportLevel: Optional[zio.aws.datasync.model.ReportLevel] = Optional.Absent,
    objectVersionIds: Optional[zio.aws.datasync.model.ObjectVersionIds] =
      Optional.Absent,
    overrides: Optional[zio.aws.datasync.model.ReportOverrides] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskReportConfig = {
    import TaskReportConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskReportConfig
      .builder()
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(outputType.map(value => value.unwrap))(_.outputType)
      .optionallyWith(reportLevel.map(value => value.unwrap))(_.reportLevel)
      .optionallyWith(objectVersionIds.map(value => value.unwrap))(
        _.objectVersionIds
      )
      .optionallyWith(overrides.map(value => value.buildAwsValue()))(
        _.overrides
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TaskReportConfig.ReadOnly =
    zio.aws.datasync.model.TaskReportConfig.wrap(buildAwsValue())
}
object TaskReportConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskReportConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskReportConfig =
      zio.aws.datasync.model.TaskReportConfig(
        destination.map(value => value.asEditable),
        outputType.map(value => value),
        reportLevel.map(value => value),
        objectVersionIds.map(value => value),
        overrides.map(value => value.asEditable)
      )
    def destination: Optional[zio.aws.datasync.model.ReportDestination.ReadOnly]
    def outputType: Optional[zio.aws.datasync.model.ReportOutputType]
    def reportLevel: Optional[zio.aws.datasync.model.ReportLevel]
    def objectVersionIds: Optional[zio.aws.datasync.model.ObjectVersionIds]
    def overrides: Optional[zio.aws.datasync.model.ReportOverrides.ReadOnly]
    def getDestination: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.ReportDestination.ReadOnly
    ] = AwsError.unwrapOptionField("destination", destination)
    def getOutputType
        : ZIO[Any, AwsError, zio.aws.datasync.model.ReportOutputType] =
      AwsError.unwrapOptionField("outputType", outputType)
    def getReportLevel: ZIO[Any, AwsError, zio.aws.datasync.model.ReportLevel] =
      AwsError.unwrapOptionField("reportLevel", reportLevel)
    def getObjectVersionIds
        : ZIO[Any, AwsError, zio.aws.datasync.model.ObjectVersionIds] =
      AwsError.unwrapOptionField("objectVersionIds", objectVersionIds)
    def getOverrides
        : ZIO[Any, AwsError, zio.aws.datasync.model.ReportOverrides.ReadOnly] =
      AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskReportConfig
  ) extends zio.aws.datasync.model.TaskReportConfig.ReadOnly {
    override val destination
        : Optional[zio.aws.datasync.model.ReportDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.datasync.model.ReportDestination.wrap(value))
    override val outputType: Optional[zio.aws.datasync.model.ReportOutputType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputType())
        .map(value => zio.aws.datasync.model.ReportOutputType.wrap(value))
    override val reportLevel: Optional[zio.aws.datasync.model.ReportLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportLevel())
        .map(value => zio.aws.datasync.model.ReportLevel.wrap(value))
    override val objectVersionIds
        : Optional[zio.aws.datasync.model.ObjectVersionIds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectVersionIds())
        .map(value => zio.aws.datasync.model.ObjectVersionIds.wrap(value))
    override val overrides
        : Optional[zio.aws.datasync.model.ReportOverrides.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value => zio.aws.datasync.model.ReportOverrides.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskReportConfig
  ): zio.aws.datasync.model.TaskReportConfig.ReadOnly = new Wrapper(impl)
}
