package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.DiscoveryNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDiscoveryJobsResponse(
    discoveryJobs: Optional[
      Iterable[zio.aws.datasync.model.DiscoveryJobListEntry]
    ] = Optional.Absent,
    nextToken: Optional[DiscoveryNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse = {
    import ListDiscoveryJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse
      .builder()
      .optionallyWith(
        discoveryJobs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.discoveryJobs)
      .optionallyWith(
        nextToken.map(value =>
          DiscoveryNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListDiscoveryJobsResponse.ReadOnly =
    zio.aws.datasync.model.ListDiscoveryJobsResponse.wrap(buildAwsValue())
}
object ListDiscoveryJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListDiscoveryJobsResponse =
      zio.aws.datasync.model.ListDiscoveryJobsResponse(
        discoveryJobs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def discoveryJobs
        : Optional[List[zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly]]
    def nextToken: Optional[DiscoveryNextToken]
    def getDiscoveryJobs: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("discoveryJobs", discoveryJobs)
    def getNextToken: ZIO[Any, AwsError, DiscoveryNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse
  ) extends zio.aws.datasync.model.ListDiscoveryJobsResponse.ReadOnly {
    override val discoveryJobs: Optional[
      List[zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.discoveryJobs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.DiscoveryJobListEntry.wrap(item)
        }.toList
      )
    override val nextToken: Optional[DiscoveryNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsResponse
  ): zio.aws.datasync.model.ListDiscoveryJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
