package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  AgentArn,
  AzureBlobSubdirectory,
  LocationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateLocationAzureBlobRequest(
    locationArn: LocationArn,
    subdirectory: Optional[AzureBlobSubdirectory] = Optional.Absent,
    authenticationType: Optional[
      zio.aws.datasync.model.AzureBlobAuthenticationType
    ] = Optional.Absent,
    sasConfiguration: Optional[
      zio.aws.datasync.model.AzureBlobSasConfiguration
    ] = Optional.Absent,
    blobType: Optional[zio.aws.datasync.model.AzureBlobType] = Optional.Absent,
    accessTier: Optional[zio.aws.datasync.model.AzureAccessTier] =
      Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobRequest = {
    import UpdateLocationAzureBlobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .optionallyWith(
        subdirectory.map(value =>
          AzureBlobSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(sasConfiguration.map(value => value.buildAwsValue()))(
        _.sasConfiguration
      )
      .optionallyWith(blobType.map(value => value.unwrap))(_.blobType)
      .optionallyWith(accessTier.map(value => value.unwrap))(_.accessTier)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.UpdateLocationAzureBlobRequest.ReadOnly =
    zio.aws.datasync.model.UpdateLocationAzureBlobRequest.wrap(buildAwsValue())
}
object UpdateLocationAzureBlobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateLocationAzureBlobRequest =
      zio.aws.datasync.model.UpdateLocationAzureBlobRequest(
        locationArn,
        subdirectory.map(value => value),
        authenticationType.map(value => value),
        sasConfiguration.map(value => value.asEditable),
        blobType.map(value => value),
        accessTier.map(value => value),
        agentArns.map(value => value)
      )
    def locationArn: LocationArn
    def subdirectory: Optional[AzureBlobSubdirectory]
    def authenticationType
        : Optional[zio.aws.datasync.model.AzureBlobAuthenticationType]
    def sasConfiguration
        : Optional[zio.aws.datasync.model.AzureBlobSasConfiguration.ReadOnly]
    def blobType: Optional[zio.aws.datasync.model.AzureBlobType]
    def accessTier: Optional[zio.aws.datasync.model.AzureAccessTier]
    def agentArns: Optional[List[AgentArn]]
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
    def getSubdirectory: ZIO[Any, AwsError, AzureBlobSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getAuthenticationType: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.AzureBlobAuthenticationType
    ] = AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getSasConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.AzureBlobSasConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sasConfiguration", sasConfiguration)
    def getBlobType: ZIO[Any, AwsError, zio.aws.datasync.model.AzureBlobType] =
      AwsError.unwrapOptionField("blobType", blobType)
    def getAccessTier
        : ZIO[Any, AwsError, zio.aws.datasync.model.AzureAccessTier] =
      AwsError.unwrapOptionField("accessTier", accessTier)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobRequest
  ) extends zio.aws.datasync.model.UpdateLocationAzureBlobRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
    override val subdirectory: Optional[AzureBlobSubdirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdirectory())
        .map(value =>
          zio.aws.datasync.model.primitives.AzureBlobSubdirectory(value)
        )
    override val authenticationType
        : Optional[zio.aws.datasync.model.AzureBlobAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value =>
          zio.aws.datasync.model.AzureBlobAuthenticationType.wrap(value)
        )
    override val sasConfiguration
        : Optional[zio.aws.datasync.model.AzureBlobSasConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sasConfiguration())
        .map(value =>
          zio.aws.datasync.model.AzureBlobSasConfiguration.wrap(value)
        )
    override val blobType: Optional[zio.aws.datasync.model.AzureBlobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blobType())
        .map(value => zio.aws.datasync.model.AzureBlobType.wrap(value))
    override val accessTier: Optional[zio.aws.datasync.model.AzureAccessTier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessTier())
        .map(value => zio.aws.datasync.model.AzureAccessTier.wrap(value))
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateLocationAzureBlobRequest
  ): zio.aws.datasync.model.UpdateLocationAzureBlobRequest.ReadOnly =
    new Wrapper(impl)
}
