package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  IamRoleArn,
  S3BucketArn,
  S3Subdirectory
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReportDestinationS3(
    subdirectory: Optional[S3Subdirectory] = Optional.Absent,
    s3BucketArn: S3BucketArn,
    bucketAccessRoleArn: IamRoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ReportDestinationS3 = {
    import ReportDestinationS3.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ReportDestinationS3
      .builder()
      .optionallyWith(
        subdirectory.map(value =>
          S3Subdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .s3BucketArn(S3BucketArn.unwrap(s3BucketArn): java.lang.String)
      .bucketAccessRoleArn(
        IamRoleArn.unwrap(bucketAccessRoleArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ReportDestinationS3.ReadOnly =
    zio.aws.datasync.model.ReportDestinationS3.wrap(buildAwsValue())
}
object ReportDestinationS3 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ReportDestinationS3
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ReportDestinationS3 =
      zio.aws.datasync.model.ReportDestinationS3(
        subdirectory.map(value => value),
        s3BucketArn,
        bucketAccessRoleArn
      )
    def subdirectory: Optional[S3Subdirectory]
    def s3BucketArn: S3BucketArn
    def bucketAccessRoleArn: IamRoleArn
    def getSubdirectory: ZIO[Any, AwsError, S3Subdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getS3BucketArn: ZIO[Any, Nothing, S3BucketArn] =
      ZIO.succeed(s3BucketArn)
    def getBucketAccessRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(bucketAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ReportDestinationS3
  ) extends zio.aws.datasync.model.ReportDestinationS3.ReadOnly {
    override val subdirectory: Optional[S3Subdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.S3Subdirectory(value))
    override val s3BucketArn: S3BucketArn =
      zio.aws.datasync.model.primitives.S3BucketArn(impl.s3BucketArn())
    override val bucketAccessRoleArn: IamRoleArn =
      zio.aws.datasync.model.primitives.IamRoleArn(impl.bucketAccessRoleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ReportDestinationS3
  ): zio.aws.datasync.model.ReportDestinationS3.ReadOnly = new Wrapper(impl)
}
