package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait AzureAccessTier {
  def unwrap: software.amazon.awssdk.services.datasync.model.AzureAccessTier
}
object AzureAccessTier {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.AzureAccessTier
  ): zio.aws.datasync.model.AzureAccessTier = value match {
    case software.amazon.awssdk.services.datasync.model.AzureAccessTier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.AzureAccessTier.HOT =>
      val r = HOT
      r
    case software.amazon.awssdk.services.datasync.model.AzureAccessTier.COOL =>
      val r = COOL
      r
    case software.amazon.awssdk.services.datasync.model.AzureAccessTier.ARCHIVE =>
      val r = ARCHIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.AzureAccessTier {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AzureAccessTier =
      software.amazon.awssdk.services.datasync.model.AzureAccessTier.UNKNOWN_TO_SDK_VERSION
  }
  case object HOT extends zio.aws.datasync.model.AzureAccessTier {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AzureAccessTier =
      software.amazon.awssdk.services.datasync.model.AzureAccessTier.HOT
  }
  case object COOL extends zio.aws.datasync.model.AzureAccessTier {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AzureAccessTier =
      software.amazon.awssdk.services.datasync.model.AzureAccessTier.COOL
  }
  case object ARCHIVE extends zio.aws.datasync.model.AzureAccessTier {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AzureAccessTier =
      software.amazon.awssdk.services.datasync.model.AzureAccessTier.ARCHIVE
  }
}
