package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait TransferMode {
  def unwrap: software.amazon.awssdk.services.datasync.model.TransferMode
}
object TransferMode {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.TransferMode
  ): zio.aws.datasync.model.TransferMode = value match {
    case software.amazon.awssdk.services.datasync.model.TransferMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.TransferMode.CHANGED =>
      val r = CHANGED
      r
    case software.amazon.awssdk.services.datasync.model.TransferMode.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.TransferMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TransferMode =
      software.amazon.awssdk.services.datasync.model.TransferMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CHANGED extends zio.aws.datasync.model.TransferMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TransferMode =
      software.amazon.awssdk.services.datasync.model.TransferMode.CHANGED
  }
  case object ALL extends zio.aws.datasync.model.TransferMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.TransferMode =
      software.amazon.awssdk.services.datasync.model.TransferMode.ALL
  }
}
