package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  PtolemyString,
  PtolemyUUID,
  NonNegativeLong
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetAppONTAPCluster(
    cifsShareCount: Optional[NonNegativeLong] = Optional.Absent,
    nfsExportedVolumes: Optional[NonNegativeLong] = Optional.Absent,
    resourceId: Optional[PtolemyUUID] = Optional.Absent,
    clusterName: Optional[PtolemyString] = Optional.Absent,
    maxP95Performance: Optional[zio.aws.datasync.model.MaxP95Performance] =
      Optional.Absent,
    clusterBlockStorageSize: Optional[NonNegativeLong] = Optional.Absent,
    clusterBlockStorageUsed: Optional[NonNegativeLong] = Optional.Absent,
    clusterBlockStorageLogicalUsed: Optional[NonNegativeLong] = Optional.Absent,
    recommendations: Optional[Iterable[zio.aws.datasync.model.Recommendation]] =
      Optional.Absent,
    recommendationStatus: Optional[
      zio.aws.datasync.model.RecommendationStatus
    ] = Optional.Absent,
    lunCount: Optional[NonNegativeLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.NetAppONTAPCluster = {
    import NetAppONTAPCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.NetAppONTAPCluster
      .builder()
      .optionallyWith(
        cifsShareCount.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.cifsShareCount)
      .optionallyWith(
        nfsExportedVolumes.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.nfsExportedVolumes)
      .optionallyWith(
        resourceId.map(value => PtolemyUUID.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        clusterName.map(value => PtolemyString.unwrap(value): java.lang.String)
      )(_.clusterName)
      .optionallyWith(maxP95Performance.map(value => value.buildAwsValue()))(
        _.maxP95Performance
      )
      .optionallyWith(
        clusterBlockStorageSize.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.clusterBlockStorageSize)
      .optionallyWith(
        clusterBlockStorageUsed.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.clusterBlockStorageUsed)
      .optionallyWith(
        clusterBlockStorageLogicalUsed.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.clusterBlockStorageLogicalUsed)
      .optionallyWith(
        recommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendations)
      .optionallyWith(recommendationStatus.map(value => value.unwrap))(
        _.recommendationStatus
      )
      .optionallyWith(
        lunCount.map(value => NonNegativeLong.unwrap(value): java.lang.Long)
      )(_.lunCount)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.NetAppONTAPCluster.ReadOnly =
    zio.aws.datasync.model.NetAppONTAPCluster.wrap(buildAwsValue())
}
object NetAppONTAPCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.NetAppONTAPCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.NetAppONTAPCluster =
      zio.aws.datasync.model.NetAppONTAPCluster(
        cifsShareCount.map(value => value),
        nfsExportedVolumes.map(value => value),
        resourceId.map(value => value),
        clusterName.map(value => value),
        maxP95Performance.map(value => value.asEditable),
        clusterBlockStorageSize.map(value => value),
        clusterBlockStorageUsed.map(value => value),
        clusterBlockStorageLogicalUsed.map(value => value),
        recommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationStatus.map(value => value),
        lunCount.map(value => value)
      )
    def cifsShareCount: Optional[NonNegativeLong]
    def nfsExportedVolumes: Optional[NonNegativeLong]
    def resourceId: Optional[PtolemyUUID]
    def clusterName: Optional[PtolemyString]
    def maxP95Performance
        : Optional[zio.aws.datasync.model.MaxP95Performance.ReadOnly]
    def clusterBlockStorageSize: Optional[NonNegativeLong]
    def clusterBlockStorageUsed: Optional[NonNegativeLong]
    def clusterBlockStorageLogicalUsed: Optional[NonNegativeLong]
    def recommendations
        : Optional[List[zio.aws.datasync.model.Recommendation.ReadOnly]]
    def recommendationStatus
        : Optional[zio.aws.datasync.model.RecommendationStatus]
    def lunCount: Optional[NonNegativeLong]
    def getCifsShareCount: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("cifsShareCount", cifsShareCount)
    def getNfsExportedVolumes: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("nfsExportedVolumes", nfsExportedVolumes)
    def getResourceId: ZIO[Any, AwsError, PtolemyUUID] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getClusterName: ZIO[Any, AwsError, PtolemyString] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getMaxP95Performance: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.MaxP95Performance.ReadOnly
    ] = AwsError.unwrapOptionField("maxP95Performance", maxP95Performance)
    def getClusterBlockStorageSize: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField(
        "clusterBlockStorageSize",
        clusterBlockStorageSize
      )
    def getClusterBlockStorageUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField(
        "clusterBlockStorageUsed",
        clusterBlockStorageUsed
      )
    def getClusterBlockStorageLogicalUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField(
        "clusterBlockStorageLogicalUsed",
        clusterBlockStorageLogicalUsed
      )
    def getRecommendations: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.Recommendation.ReadOnly
    ]] = AwsError.unwrapOptionField("recommendations", recommendations)
    def getRecommendationStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.RecommendationStatus] =
      AwsError.unwrapOptionField("recommendationStatus", recommendationStatus)
    def getLunCount: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("lunCount", lunCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.NetAppONTAPCluster
  ) extends zio.aws.datasync.model.NetAppONTAPCluster.ReadOnly {
    override val cifsShareCount: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cifsShareCount())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val nfsExportedVolumes: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nfsExportedVolumes())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val resourceId: Optional[PtolemyUUID] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.datasync.model.primitives.PtolemyUUID(value))
    override val clusterName: Optional[PtolemyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => zio.aws.datasync.model.primitives.PtolemyString(value))
    override val maxP95Performance
        : Optional[zio.aws.datasync.model.MaxP95Performance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxP95Performance())
        .map(value => zio.aws.datasync.model.MaxP95Performance.wrap(value))
    override val clusterBlockStorageSize: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterBlockStorageSize())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val clusterBlockStorageUsed: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterBlockStorageUsed())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val clusterBlockStorageLogicalUsed: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterBlockStorageLogicalUsed())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val recommendations
        : Optional[List[zio.aws.datasync.model.Recommendation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.Recommendation.wrap(item)
          }.toList
        )
    override val recommendationStatus
        : Optional[zio.aws.datasync.model.RecommendationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationStatus())
        .map(value => zio.aws.datasync.model.RecommendationStatus.wrap(value))
    override val lunCount: Optional[NonNegativeLong] = zio.aws.core.internal
      .optionalFromNullable(impl.lunCount())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.NetAppONTAPCluster
  ): zio.aws.datasync.model.NetAppONTAPCluster.ReadOnly = new Wrapper(impl)
}
