package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait DiscoveryResourceType {
  def unwrap
      : software.amazon.awssdk.services.datasync.model.DiscoveryResourceType
}
object DiscoveryResourceType {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.DiscoveryResourceType
  ): zio.aws.datasync.model.DiscoveryResourceType = value match {
    case software.amazon.awssdk.services.datasync.model.DiscoveryResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryResourceType.SVM =>
      val r = SVM
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryResourceType.VOLUME =>
      val r = VOLUME
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryResourceType.CLUSTER =>
      val r = CLUSTER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.DiscoveryResourceType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryResourceType =
      software.amazon.awssdk.services.datasync.model.DiscoveryResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object SVM extends zio.aws.datasync.model.DiscoveryResourceType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryResourceType =
      software.amazon.awssdk.services.datasync.model.DiscoveryResourceType.SVM
  }
  case object VOLUME extends zio.aws.datasync.model.DiscoveryResourceType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryResourceType =
      software.amazon.awssdk.services.datasync.model.DiscoveryResourceType.VOLUME
  }
  case object CLUSTER extends zio.aws.datasync.model.DiscoveryResourceType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryResourceType =
      software.amazon.awssdk.services.datasync.model.DiscoveryResourceType.CLUSTER
  }
}
