package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{Time, TagValue, AgentArn}
import scala.jdk.CollectionConverters._
final case class DescribeAgentResponse(
    agentArn: Optional[AgentArn] = Optional.Absent,
    name: Optional[TagValue] = Optional.Absent,
    status: Optional[zio.aws.datasync.model.AgentStatus] = Optional.Absent,
    lastConnectionTime: Optional[Time] = Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent,
    endpointType: Optional[zio.aws.datasync.model.EndpointType] =
      Optional.Absent,
    privateLinkConfig: Optional[zio.aws.datasync.model.PrivateLinkConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeAgentResponse = {
    import DescribeAgentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeAgentResponse
      .builder()
      .optionallyWith(
        agentArn.map(value => AgentArn.unwrap(value): java.lang.String)
      )(_.agentArn)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastConnectionTime.map(value => Time.unwrap(value): Instant)
      )(_.lastConnectionTime)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(privateLinkConfig.map(value => value.buildAwsValue()))(
        _.privateLinkConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeAgentResponse.ReadOnly =
    zio.aws.datasync.model.DescribeAgentResponse.wrap(buildAwsValue())
}
object DescribeAgentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeAgentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeAgentResponse =
      zio.aws.datasync.model.DescribeAgentResponse(
        agentArn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        lastConnectionTime.map(value => value),
        creationTime.map(value => value),
        endpointType.map(value => value),
        privateLinkConfig.map(value => value.asEditable)
      )
    def agentArn: Optional[AgentArn]
    def name: Optional[TagValue]
    def status: Optional[zio.aws.datasync.model.AgentStatus]
    def lastConnectionTime: Optional[Time]
    def creationTime: Optional[Time]
    def endpointType: Optional[zio.aws.datasync.model.EndpointType]
    def privateLinkConfig
        : Optional[zio.aws.datasync.model.PrivateLinkConfig.ReadOnly]
    def getAgentArn: ZIO[Any, AwsError, AgentArn] =
      AwsError.unwrapOptionField("agentArn", agentArn)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.datasync.model.AgentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastConnectionTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("lastConnectionTime", lastConnectionTime)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.datasync.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getPrivateLinkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.PrivateLinkConfig.ReadOnly
    ] = AwsError.unwrapOptionField("privateLinkConfig", privateLinkConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeAgentResponse
  ) extends zio.aws.datasync.model.DescribeAgentResponse.ReadOnly {
    override val agentArn: Optional[AgentArn] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArn())
      .map(value => zio.aws.datasync.model.primitives.AgentArn(value))
    override val name: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val status: Optional[zio.aws.datasync.model.AgentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datasync.model.AgentStatus.wrap(value))
    override val lastConnectionTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.lastConnectionTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val endpointType: Optional[zio.aws.datasync.model.EndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointType())
        .map(value => zio.aws.datasync.model.EndpointType.wrap(value))
    override val privateLinkConfig
        : Optional[zio.aws.datasync.model.PrivateLinkConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateLinkConfig())
        .map(value => zio.aws.datasync.model.PrivateLinkConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeAgentResponse
  ): zio.aws.datasync.model.DescribeAgentResponse.ReadOnly = new Wrapper(impl)
}
