package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  ObjectStorageServerPort,
  ObjectStorageCertificate,
  ObjectStorageAccessKey,
  ObjectStorageSecretKey,
  ObjectStorageBucketName,
  S3Subdirectory,
  ServerHostname,
  AgentArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateLocationObjectStorageRequest(
    serverHostname: ServerHostname,
    serverPort: Optional[ObjectStorageServerPort] = Optional.Absent,
    serverProtocol: Optional[
      zio.aws.datasync.model.ObjectStorageServerProtocol
    ] = Optional.Absent,
    subdirectory: Optional[S3Subdirectory] = Optional.Absent,
    bucketName: ObjectStorageBucketName,
    accessKey: Optional[ObjectStorageAccessKey] = Optional.Absent,
    secretKey: Optional[ObjectStorageSecretKey] = Optional.Absent,
    agentArns: Iterable[AgentArn],
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent,
    serverCertificate: Optional[ObjectStorageCertificate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest = {
    import CreateLocationObjectStorageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest
      .builder()
      .serverHostname(ServerHostname.unwrap(serverHostname): java.lang.String)
      .optionallyWith(
        serverPort.map(value => ObjectStorageServerPort.unwrap(value): Integer)
      )(_.serverPort)
      .optionallyWith(serverProtocol.map(value => value.unwrap))(
        _.serverProtocol
      )
      .optionallyWith(
        subdirectory.map(value =>
          S3Subdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .bucketName(ObjectStorageBucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        accessKey.map(value =>
          ObjectStorageAccessKey.unwrap(value): java.lang.String
        )
      )(_.accessKey)
      .optionallyWith(
        secretKey.map(value =>
          ObjectStorageSecretKey.unwrap(value): java.lang.String
        )
      )(_.secretKey)
      .agentArns(agentArns.map { item =>
        AgentArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        serverCertificate.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.serverCertificate)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationObjectStorageRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationObjectStorageRequest
      .wrap(buildAwsValue())
}
object CreateLocationObjectStorageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationObjectStorageRequest =
      zio.aws.datasync.model.CreateLocationObjectStorageRequest(
        serverHostname,
        serverPort.map(value => value),
        serverProtocol.map(value => value),
        subdirectory.map(value => value),
        bucketName,
        accessKey.map(value => value),
        secretKey.map(value => value),
        agentArns,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serverCertificate.map(value => value)
      )
    def serverHostname: ServerHostname
    def serverPort: Optional[ObjectStorageServerPort]
    def serverProtocol
        : Optional[zio.aws.datasync.model.ObjectStorageServerProtocol]
    def subdirectory: Optional[S3Subdirectory]
    def bucketName: ObjectStorageBucketName
    def accessKey: Optional[ObjectStorageAccessKey]
    def secretKey: Optional[ObjectStorageSecretKey]
    def agentArns: List[AgentArn]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def serverCertificate: Optional[ObjectStorageCertificate]
    def getServerHostname: ZIO[Any, Nothing, ServerHostname] =
      ZIO.succeed(serverHostname)
    def getServerPort: ZIO[Any, AwsError, ObjectStorageServerPort] =
      AwsError.unwrapOptionField("serverPort", serverPort)
    def getServerProtocol: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.ObjectStorageServerProtocol
    ] = AwsError.unwrapOptionField("serverProtocol", serverProtocol)
    def getSubdirectory: ZIO[Any, AwsError, S3Subdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getBucketName: ZIO[Any, Nothing, ObjectStorageBucketName] =
      ZIO.succeed(bucketName)
    def getAccessKey: ZIO[Any, AwsError, ObjectStorageAccessKey] =
      AwsError.unwrapOptionField("accessKey", accessKey)
    def getSecretKey: ZIO[Any, AwsError, ObjectStorageSecretKey] =
      AwsError.unwrapOptionField("secretKey", secretKey)
    def getAgentArns: ZIO[Any, Nothing, List[AgentArn]] = ZIO.succeed(agentArns)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getServerCertificate: ZIO[Any, AwsError, ObjectStorageCertificate] =
      AwsError.unwrapOptionField("serverCertificate", serverCertificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest
  ) extends zio.aws.datasync.model.CreateLocationObjectStorageRequest.ReadOnly {
    override val serverHostname: ServerHostname =
      zio.aws.datasync.model.primitives.ServerHostname(impl.serverHostname())
    override val serverPort: Optional[ObjectStorageServerPort] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverPort())
        .map(value =>
          zio.aws.datasync.model.primitives.ObjectStorageServerPort(value)
        )
    override val serverProtocol
        : Optional[zio.aws.datasync.model.ObjectStorageServerProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverProtocol())
        .map(value =>
          zio.aws.datasync.model.ObjectStorageServerProtocol.wrap(value)
        )
    override val subdirectory: Optional[S3Subdirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.subdirectory())
      .map(value => zio.aws.datasync.model.primitives.S3Subdirectory(value))
    override val bucketName: ObjectStorageBucketName =
      zio.aws.datasync.model.primitives
        .ObjectStorageBucketName(impl.bucketName())
    override val accessKey: Optional[ObjectStorageAccessKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessKey())
        .map(value =>
          zio.aws.datasync.model.primitives.ObjectStorageAccessKey(value)
        )
    override val secretKey: Optional[ObjectStorageSecretKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretKey())
        .map(value =>
          zio.aws.datasync.model.primitives.ObjectStorageSecretKey(value)
        )
    override val agentArns: List[AgentArn] = impl
      .agentArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.AgentArn(item)
      }
      .toList
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
    override val serverCertificate: Optional[ObjectStorageCertificate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverCertificate())
        .map(value =>
          zio.aws.datasync.model.primitives.ObjectStorageCertificate(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest
  ): zio.aws.datasync.model.CreateLocationObjectStorageRequest.ReadOnly =
    new Wrapper(impl)
}
