package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocationFsxOpenZfsResponse(
    locationArn: Optional[LocationArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsResponse = {
    import CreateLocationFsxOpenZfsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse.ReadOnly =
    zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse
      .wrap(buildAwsValue())
}
object CreateLocationFsxOpenZfsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse =
      zio.aws.datasync.model
        .CreateLocationFsxOpenZfsResponse(locationArn.map(value => value))
    def locationArn: Optional[LocationArn]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsResponse
  ) extends zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsResponse
  ): zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse.ReadOnly =
    new Wrapper(impl)
}
