package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaskExecutionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartTaskExecutionResponse(
    taskExecutionArn: Optional[TaskExecutionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse = {
    import StartTaskExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse
      .builder()
      .optionallyWith(
        taskExecutionArn.map(value =>
          TaskExecutionArn.unwrap(value): java.lang.String
        )
      )(_.taskExecutionArn)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly =
    zio.aws.datasync.model.StartTaskExecutionResponse.wrap(buildAwsValue())
}
object StartTaskExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.StartTaskExecutionResponse =
      zio.aws.datasync.model
        .StartTaskExecutionResponse(taskExecutionArn.map(value => value))
    def taskExecutionArn: Optional[TaskExecutionArn]
    def getTaskExecutionArn: ZIO[Any, AwsError, TaskExecutionArn] =
      AwsError.unwrapOptionField("taskExecutionArn", taskExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse
  ) extends zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly {
    override val taskExecutionArn: Optional[TaskExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskExecutionArn())
        .map(value => zio.aws.datasync.model.primitives.TaskExecutionArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.StartTaskExecutionResponse
  ): zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
