package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait EfsInTransitEncryption {
  def unwrap
      : software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption
}
object EfsInTransitEncryption {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption
  ): zio.aws.datasync.model.EfsInTransitEncryption = value match {
    case software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption.TLS1_2 =>
      val r = TLS1_2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.EfsInTransitEncryption {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption =
      software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.datasync.model.EfsInTransitEncryption {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption =
      software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption.NONE
  }
  case object TLS1_2 extends zio.aws.datasync.model.EfsInTransitEncryption {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption =
      software.amazon.awssdk.services.datasync.model.EfsInTransitEncryption.TLS1_2
  }
}
