package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Time,
  Ec2SecurityGroupArn,
  LocationUri,
  LocationArn
}
import scala.jdk.CollectionConverters._
final case class DescribeLocationFsxLustreResponse(
    locationArn: Optional[LocationArn] = Optional.Absent,
    locationUri: Optional[LocationUri] = Optional.Absent,
    securityGroupArns: Optional[Iterable[Ec2SecurityGroupArn]] =
      Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreResponse = {
    import DescribeLocationFsxLustreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        securityGroupArns.map(value =>
          value.map { item =>
            Ec2SecurityGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupArns)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationFsxLustreResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationFsxLustreResponse
      .wrap(buildAwsValue())
}
object DescribeLocationFsxLustreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationFsxLustreResponse =
      zio.aws.datasync.model.DescribeLocationFsxLustreResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        securityGroupArns.map(value => value),
        creationTime.map(value => value)
      )
    def locationArn: Optional[LocationArn]
    def locationUri: Optional[LocationUri]
    def securityGroupArns: Optional[List[Ec2SecurityGroupArn]]
    def creationTime: Optional[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getSecurityGroupArns: ZIO[Any, AwsError, List[Ec2SecurityGroupArn]] =
      AwsError.unwrapOptionField("securityGroupArns", securityGroupArns)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreResponse
  ) extends zio.aws.datasync.model.DescribeLocationFsxLustreResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Optional[LocationUri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val securityGroupArns: Optional[List[Ec2SecurityGroupArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
          }.toList
        )
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreResponse
  ): zio.aws.datasync.model.DescribeLocationFsxLustreResponse.ReadOnly =
    new Wrapper(impl)
}
