package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait VerifyMode {
  def unwrap: software.amazon.awssdk.services.datasync.model.VerifyMode
}
object VerifyMode {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.VerifyMode
  ): zio.aws.datasync.model.VerifyMode = value match {
    case software.amazon.awssdk.services.datasync.model.VerifyMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.VerifyMode.POINT_IN_TIME_CONSISTENT =>
      val r = POINT_IN_TIME_CONSISTENT
      r
    case software.amazon.awssdk.services.datasync.model.VerifyMode.ONLY_FILES_TRANSFERRED =>
      val r = ONLY_FILES_TRANSFERRED
      r
    case software.amazon.awssdk.services.datasync.model.VerifyMode.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.VerifyMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.VerifyMode =
      software.amazon.awssdk.services.datasync.model.VerifyMode.UNKNOWN_TO_SDK_VERSION
  }
  case object POINT_IN_TIME_CONSISTENT
      extends zio.aws.datasync.model.VerifyMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.VerifyMode =
      software.amazon.awssdk.services.datasync.model.VerifyMode.POINT_IN_TIME_CONSISTENT
  }
  case object ONLY_FILES_TRANSFERRED extends zio.aws.datasync.model.VerifyMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.VerifyMode =
      software.amazon.awssdk.services.datasync.model.VerifyMode.ONLY_FILES_TRANSFERRED
  }
  case object NONE extends zio.aws.datasync.model.VerifyMode {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.VerifyMode =
      software.amazon.awssdk.services.datasync.model.VerifyMode.NONE
  }
}
